/*{
	"GUID":"49D37319-8F37-4593-BBAF-9FF0A6307C01",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"sketch.png"
		}
	]
}*/
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 Screen(vec4 base, vec4 blend)
{
    vec4 white = (vec4)(1.0f);
    vec4 result = white - ((white - blend) * (white - base));
    return result;
}

vec4 softlight(vec4 base, vec4 blend)
{
    vec4 result = 2.0f * base * blend + base * base - 2.0f * base * base * blend;

    return result;
}

vec4 ColorDodge(vec4 base, vec4 blend)
{
    vec4 result=(vec4)(0.0f);
    vec4 white = (vec4)(1.0f);
    if(1.0f-blend.x<1.0e-5f)
        result.x=blend.x;
    else
        result.x = base.x / (1.0f - blend.x);
    if(1.0f-blend.y<1.0e-5f)
        result.y=blend.y;
    else
        result.y = base.y / (1.0f - blend.y);
    if(1.0f-blend.z<1.0e-5)
        result.z=blend.z;
    else
        result.z = base.z / (1.0f - blend.z);
    if(1.0f-blend.w<1.0e-5f)
        result.w=blend.w;
    else
        result.w = base.w / (1.0f - blend.w);
    
    return result;
   
}

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc);
}

__kernel void MAIN(
      __read_only image2d_t input1,
	  __read_only image2d_t input2,
      __write_only image2d_t dest_data,        //Data in global memory
      __global FilterParam* param,
	  int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	vec2 offset[9] = 
                { 
                        (vec2)(-1.0f/W, -1.0f/H), 
                        (vec2)(0.0f, -1.0f/H), 
                        (vec2)(1.0f/W, -1.0f/H), 
                        (vec2)(-1.0f/W,    0.0f), 
                        (vec2)(0.0f,    0.0f), 
                        (vec2)(1.0f/W,    0.0f), 
                        (vec2)(-1.0f/W,  1.0f/H), 
                        (vec2)(0.0f,  1.0f/H), 
                        (vec2)(1.0f/W,  1.0f/H)
                };
				
    vec4 tempColor;
    vec4 result = INPUTSRC(input1, param, tc);
	vec4 col = result;
    vec4 blend = INPUT(input2, (vec2)(tc.x, 1.0f - tc.y));
    float maxGray = 0.0f;
    float sample[9];
    for(int i=0; i < 9; i++)
    {
        tempColor = INPUTSRC(input1,  param, tc + offset[i]);
        sample[i] = dot(tempColor.xyz, (vec3)(0.114f, 0.587f, 0.299f));
        maxGray = max(sample[i], maxGray);
    }
    float minGray = 1.0f - maxGray;
    vec4 min = (vec4)((vec3)(minGray), 1.0f);
    result = softlight((vec4)((vec3)(sample[4]), 1.0f), blend);
    result = ColorDodge(result, min);
	result.w = col.w;
	write_imagef(dest_data, coordinate, col*(1.0f - (float)alpha/100.0f) + result*(float)alpha/100.0f);
}
